/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

public abstract class TimedGenerator {
    int sampleRate;
    int clock;
    int period;
    double stepsPerSample;
    int counter;

    public abstract double stepsPerCycle();

    public TimedGenerator() {
    }

    public TimedGenerator(int _clock, int _sampleRate) {
        this.sampleRate = _sampleRate;
        this.clock = _clock;
        this.stepsPerSample = (double)this.clock / this.stepsPerCycle() / (double)this.sampleRate;
        this.reset();
    }

    public void setPeriod(int _period) {
        this.period = (int)((double)_period / this.stepsPerSample);
        if (this.period <= 0) {
            this.period = 1;
        }
    }

    protected int updateCounter() {
        --this.counter;
        int numStateChanges = 0;
        while (this.counter < 0) {
            ++numStateChanges;
            this.counter += this.period;
        }
        return numStateChanges;
    }

    public void reset() {
        this.counter = 0;
        this.period = 1;
    }
}

